/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.util.SimpleStringBuffer;

public class IndentableStringBuffer {
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final char LINE_SEP_CHAR = LINE_SEP.charAt(0);
    protected static final String COMMA_LINE_SEP = ",".concat(String.valueOf(LINE_SEP));
    protected int preferredLineWidth = 78;
    protected int horizPos;
    private int savedHorizPos;
    protected int virtualCharCount;
    protected SimpleStringBuffer outputBuffer;
    protected SimpleStringBuffer buffer = this.outputBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer formerBuffer;
    private SimpleStringBuffer lineBreakBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer tmpBuffer = new SimpleStringBuffer();
    protected static final int NUM_SPACES_PER_INDENT = 2;
    protected int indent = 0;
    public String tabString = null;

    public final void add(char c) {
        this.buffer.append(c);
        ++this.horizPos;
        ++this.virtualCharCount;
    }

    public final void add(int i) {
        this.add(Integer.toString(i));
    }

    public final void add(String s) {
        this.buffer.append(s);
        int l = s.length();
        this.horizPos += l;
        this.virtualCharCount += l;
    }

    public final void addln(int i) {
        this.addln(Integer.toString(i));
    }

    public final void addln(long l) {
        this.addln(Long.toString(l));
    }

    public final void addln(String s) {
        this.buffer.append(s);
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        this.virtualCharCount += s.length() + 1;
    }

    public final void beginLineBreaking() {
        this.savedHorizPos = this.horizPos;
        this.lineBreakBuffer.reset();
        this.formerBuffer = this.buffer;
        this.buffer = this.lineBreakBuffer;
    }

    public final void endLineBreaking() {
        this.buffer = this.formerBuffer;
        this.horizPos = this.savedHorizPos;
        boolean firstTime = true;
        String contents = this.lineBreakBuffer.toString();
        int len = contents.length();
        for (int i = 0; i < len; ++i) {
            char c = contents.charAt(i);
            if (c == ',') {
                if (i + 1 < len && contents.charAt(i + 1) == ' ') {
                    ++i;
                }
                this.tmpBuffer.append(',');
                firstTime = this.lineBreakWord(firstTime);
                continue;
            }
            this.tmpBuffer.append(c);
        }
        this.lineBreakWord(firstTime);
    }

    public final void ensureIndent() {
        if (this.horizPos == 0) {
            this.indent();
        }
    }

    public final void ensureNewLine() {
        if (this.horizPos != 0) {
            this.newLine();
        }
    }

    public final String getCurrentIndent() {
        if (this.tabString == null) {
            String ret = "";
            for (int i = 0; i < this.indent * 2; ++i) {
                ret = String.valueOf(ret).concat(String.valueOf(' '));
            }
            return ret;
        }
        return this.tabString;
    }

    public final int horizPos() {
        return this.horizPos;
    }

    public final void horizPos(int newIndent) {
        this.indent = newIndent;
    }

    public final void indent() {
        if (this.tabString == null) {
            int n = 2 * this.indent;
            this.buffer.append(' ', n);
            this.horizPos += n;
        } else {
            this.buffer.append(this.tabString);
            this.horizPos += this.tabString.length();
        }
    }

    public final void indent(int indentChange) {
        this.indent += indentChange;
    }

    public final void indentTo(int numSpaces) {
        this.buffer.append(' ', numSpaces);
        this.horizPos += numSpaces;
    }

    public int length() {
        return this.buffer.toString().length();
    }

    private final boolean lineBreakWord(boolean firstTime) {
        if (this.tmpBuffer.length() > 0) {
            String word = this.tmpBuffer.toString();
            this.tmpBuffer.reset();
            if (firstTime) {
                this.add(word);
            } else if (this.horizPos + 1 + word.length() > this.preferredLineWidth && this.horizPos > this.savedHorizPos) {
                this.newLine();
                this.indentTo(this.savedHorizPos);
                this.add(word);
            } else {
                this.add(' ');
                this.add(word);
            }
            return false;
        }
        return firstTime;
    }

    public final void newLine() {
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        ++this.virtualCharCount;
    }

    public final void print(String s) {
        this.indent();
        this.buffer.append(s);
        int l = s.length();
        this.horizPos += l;
        this.virtualCharCount += l;
    }

    public final void printUnindented(String s) {
        this.buffer.append(s);
        int l = s.length();
        this.horizPos += l;
        this.virtualCharCount += l;
    }

    public final void println(String s) {
        this.indent();
        this.buffer.append(s);
        this.buffer.append(LINE_SEP);
        this.horizPos = 0;
        this.virtualCharCount += s.length() + 1;
    }

    public final void reset() {
        this.horizPos = 0;
        this.savedHorizPos = 0;
        this.virtualCharCount = 0;
        this.indent = 0;
        this.tabString = null;
        if (this.outputBuffer != null) {
            this.outputBuffer.reset();
        }
        if (this.formerBuffer != null) {
            this.formerBuffer.reset();
        }
        if (this.lineBreakBuffer != null) {
            this.lineBreakBuffer.reset();
        }
        if (this.tmpBuffer != null) {
            this.tmpBuffer.reset();
        }
        this.buffer = this.outputBuffer;
    }

    public final void setIndent(int newIndent) {
        this.indent = newIndent;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

